from collections import defaultdict
from libraries.utils import shortname


def json_to_bsconfig(instances):
    tags = defaultdict(set)
    s_lookup = defaultdict(set)
    i_lookup = defaultdict(set)
    tier = None
    for instance in instances:
        short_name = shortname(instance['hostname'])
        short_instance = '{}:{}'.format(short_name, instance['port'])
        s_lookup[instance['shard_name']].add(short_name)
        i_lookup[instance['shard_name']].add(short_instance)
        for tag in instance['tags']:
            tags[tag].add(short_instance)
        if tier is None:
            tier = _find_tier(instance['tags'])

    return '\n\n'.join(
        [
            _format_s_lookup(s_lookup),
            _format_i_lookup(i_lookup),
            _format_shard_tag(s_lookup.keys(), tier)
        ] + [_format_auto_tag(name, tags[name]) for name in sorted(tags.iterkeys())]
    )


def _where_built(shard_name):
    if '-' in shard_name:
        return shard_name.split('-')[0]
    return 'none'


def _find_tier(tags):
    for tag in tags:
        if tag.startswith('a_tier_'):
            return tag.partition('a_tier_')[2]
    return 'none'


def _format_s_lookup(s_lookup):
    res = []
    for shard, hosts in s_lookup.iteritems():
        res.append(' '.join([shard, _where_built(shard)] + sorted(host for host in hosts)))
    if 'none' not in s_lookup:
        res.append('none none')
    return '\n'.join(['%slookup'] + sorted(res))


def _format_i_lookup(i_lookup):
    res = []
    for shard, instances in i_lookup.iteritems():
        res.append(' '.join([shard] + sorted(h_p for h_p in instances)))
    if 'none' not in i_lookup:
        res.append('none')
    return '\n'.join(['%ilookup'] + sorted(res))


def _format_shard_tag(shard_names, tier_name):
    res = ['%shard_tag ' + tier_name]
    res += sorted(shard for shard in shard_names)
    return '\n'.join(res)


def _format_auto_tag(tag_name, instances):
    res = ['%instance_tag_auto ' + tag_name]
    res += sorted(host_port for host_port in instances)
    return '\n'.join(res)
