import pymongo
from .mongo import gencfg_constants


def get_latest_commit():
    for record in gencfg_constants().find({'type': 'hbf_macroses'}, projection={'commit': 1}, sort=[('commit', pymongo.DESCENDING)], limit=1):
        commit = record['commit']
        return commit


def load_hbf_macroses(commit=None):
    commit = commit or get_latest_commit()
    return list(gencfg_constants().find_one({'type': 'hbf_macroses', 'commit': commit})['value'])
