from .utils import get_latest_commit
from .mongo import gencfg_hosts_to_groups
from .mongo import gencfg_hosts_to_hardware


def load_hosts_to_groups(commit=None):
    commit = commit or get_latest_commit(gencfg_hosts_to_groups())
    return list(gencfg_hosts_to_groups().find({'commit': commit}, projection={'_id': 0, 'commit': 0, 'datetime': 0}))


def load_hosts_to_hardware(commit=None):
    commit = commit or get_latest_commit(gencfg_hosts_to_hardware())
    return list(gencfg_hosts_to_hardware().find({'commit': commit}, projection={'_id': 0, 'commit': 0, 'datetime': 0}))
