from libraries.utils import memoize
import pymongo

from libraries.mongo_params import ALL_HEARTBEAT_A_MONGODB, ALL_HEARTBEAT_C_MONGODB, ALL_HEARTBEAT_D_MONGODB


@memoize
def groups():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_A_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_A_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_A_MONGODB.read_preference
    )['topology_commits']['groups']


@memoize
def tags():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['tags']


@memoize
def commits():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['commits']


@memoize
def searcher_lookup():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['search_lookup']


@memoize
def search_map():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['search_map']


@memoize
def gencfg_trunk():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['gencfg_trunk']


@memoize
def gencfg_dns():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['gencfg_dns']


@memoize
def staff_group_persons_map():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        connectTimeoutMS=5000,
        replicaSet=ALL_HEARTBEAT_C_MONGODB.replicaset,
        w='majority',
        wtimeout=15000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference,
    )['staff_cache']['group_persons_map']


@memoize
def gencfg_slbs():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['slbs']


@memoize
def gencfg_tags_ranges():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['tags_ranges']


@memoize
def gencfg_constants():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['gencfg_constants']


@memoize
def instances_tags():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_D_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_D_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_D_MONGODB.read_preference
    )['topology_commits']['instances_tags2']


@memoize
def gencfg_hosts_to_groups():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['hosts_to_groups']


@memoize
def gencfg_hosts_to_hardware():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['hosts_to_hardware']


@memoize
def cpumodels():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology_commits']['cpumodels']
