from .mongo import gencfg_tags_ranges


def get_tag_by_commit(commit):
    records = gencfg_tags_ranges().find(
        {'$and': [
            # last_commit >= commit >= first_commit
            {'last_commit': {'$gte': commit}},
            {'first_commit': {'$lte': commit}}
        ]}
    )

    return None if records.count() != 1 else records[0].get('tag')
