import os
import zlib
import msgpack
import pymongo


def tag_to_version(tag):
    tag = tag.partition('stable-')[2]
    major, minor = tag.split('-')
    minor = minor[1:]
    return int(major) * 1000000 + int(minor)


MAGIC_NUMBER = 1000000000


def version_to_tag(version):
    version = int(version)
    major, minor = divmod(version, 1000000)
    tag = 'stable-' + str(major) + '-r' + str(minor)
    return tag


def is_trunk(version):
    return int(version) > MAGIC_NUMBER


def trunk_to_commit(version):
    return str(int(version) % MAGIC_NUMBER)


def commit_to_trunk(commit):
    return int(trunk_to_commit(commit)) + MAGIC_NUMBER


def get_commits():
    text = os.popen('svn ls -v svn+ssh://arcadia.yandex.ru/arc/gencfgmain/tags').read()
    text = text.split('\n')
    res = {}
    for line in text:
        line = line.split(' ')
        key, value = line[-1].strip('/'), line[0]
        res[key] = str(value)
    return res


def get_tags():
    return {value: key for key, value in get_commits().items()}


def zipped(data):
    return zlib.compress(msgpack.dumps(data))


def unzipped(data, use_list=False):
    return msgpack.loads(zlib.decompress(data), use_list=use_list)


def get_latest_commit(collection):
    for record in collection.find({}, projection={'commit': 1}, sort=[('commit', pymongo.DESCENDING)], limit=1):
        commit = record['commit']
        return commit
