import datetime


class memoize(object):
    cache = {}

    def __init__(self, func):
        self.func = func

    def __call__(self, *args, **kwargs):
        if kwargs:
            key = tuple(yield_from_each_it((self.func,), args, sorted(kwargs.iteritems())))
        else:
            key = (self.func,) + args
        if key not in self.cache:
            res = self.func(*args, **kwargs)
            if not isinstance(res, self.NotSave):
                self.cache[key] = res
                return res
            return res.res
        return self.cache[key]

    class NotSave(object):
        def __init__(self, res):
            self.res = res


def yield_from_each_it(*iterables):
    for it in iterables:
        for one in it:
            yield one


class singleton(object):
    cache = {}

    def __init__(self, func):
        self.func = func

    def __call__(self):
        if self.func not in singleton.cache:
            singleton.cache[self.func] = self.func()
        return singleton.cache[self.func]


def shortname(host):
    if host.endswith('.yt.yandex.net'):
        return host.rsplit('.', 4)[0]
    return host.replace('.search.yandex.net', '').replace('.yandex.ru', '')


def timestamp(t):
    return (t - datetime.datetime(1970, 1, 1)).total_seconds()
