PY2_LIBRARY()

PEERDIR(
    contrib/python/msgpack
    contrib/python/PyYAML
    contrib/python/pymongo
    contrib/python/requests
    contrib/python/gevent

    library/python/resource
    yp/python/client

    skynet/api
    skynet/library
    skynet/kernel

    infra/callisto/libraries/discovery
)

RESOURCE(
    hardware/models.yaml /hwmodels
)

PY_SRCS(
    NAMESPACE libraries

    cms/__init__.py
    cms/registry.py

    online_state/__init__.py
    online_state/instances.py
    online_state/online_state.py
    online_state/state_obj.py

    outliers/__init__.py
    outliers/analyzer.py
    outliers/array.py
    outliers/utils.py

    hardware/__init__.py
    hardware/hosts.py
    hardware/models.py
    hardware/vms.py

    resolver/__init__.py
    resolver/clause_resolver.py
    resolver/descent.py
    resolver/errors.py
    resolver/expression.py
    resolver/helpers.py
    resolver/hostsource.py
    resolver/lexer.py
    resolver/parser.py
    resolver/resolverbase.py

    yp_sd/endpoint.py
    yp_sd/endpoint_set.py
    yp_sd/yp_utils.py
    yp_sd/lock.py
    resolve_yp/__init__.py

    topology/__init__.py
    topology/bsconfig.py
    topology/groups.py
    topology/instances.py
    topology/mongo.py
    topology/search_map.py
    topology/searcher_lookup.py
    topology/staff.py
    topology/utils.py
    topology/slbs.py
    topology/tags.py
    topology/hbf_macroses.py
    topology/host_info.py
    topology/cpumodels.py

    containers/__init__.py
    containers/clusters.py
    containers/containers.py
    containers/limits.py
    containers/mongo.py

    waitinfo/__init__.py
    waitinfo/waitinfo.py

    hosts_renaming.py
    json_diff.py
    mongo_params.py
    utils.py
)

OWNER(okats)

END()
