import logging
import contextlib

import infra.callisto.libraries.discovery as discovery


LOCK_PATH = '//home/cajuper/yp_sd'
PROXY = 'locke'


@contextlib.contextmanager
def _fake_lock_path():
    _log.info('fake lock path')
    try:
        yield
    finally:
        _log.info('fake unlock path')


def lock_path(node, readonly):
    if readonly:
        return _fake_lock_path()
    else:
        return discovery.lock_path(PROXY, LOCK_PATH + '/' + node)


_log = logging.getLogger(__name__)
