from utils import configure_log


def main():
    args = parse_args()
    configure_log(debug=args.debug, beta=args.beta)
    set_proc_title(args.port)

    # hack
    try:
        import requests_2_13_0
        assert requests_2_13_0.__version__ == '2.13.0'
    except ImportError:
        import requests as requests_2_13_0

    from blinov import reconfigure_resolver
    reconfigure_resolver('localhost', args.resolver_port)

    import libraries.hardware
    libraries.hardware.load_singletons()

    from web import Web
    Web(args.port, args.warmup).start()


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(description='Clusterstate web server')
    parser.add_argument('-p', '--port', default=20213, help='listen port')
    parser.add_argument('--warmup', dest='warmup', action='store_true', help='[default] warm up before port opening')
    parser.add_argument('--no-warmup', dest='warmup', action='store_false', help="don't warm up")
    parser.add_argument('--debug', dest='debug', default=False, action='store_true', help='fancy logging to stdout')
    parser.add_argument('--beta', dest='beta', default=False, action='store_true', help='run as beta (affects logging)')
    parser.add_argument('--resolver-port', dest='resolver_port', default=20214, help='local resolver port')
    parser.set_defaults(warmup=True)
    return parser.parse_args()


def set_proc_title(port):
    from kernel.util.console import setProcTitle
    setProcTitle('clst [{}]'.format(port))


if __name__ == '__main__':
    main()
