import pymongo
from collections import namedtuple

MongoStorage = namedtuple('MongoStorage', ['uri', 'replicaset', 'read_preference'])

ALL_HEARTBEAT_B_MONGODB = MongoStorage(
    uri=','.join([
        'myt0-4011.search.yandex.net:27017',
        'myt0-4017.search.yandex.net:27017',
        'sas1-6859.search.yandex.net:27017',
        'sas1-8999.search.yandex.net:27017',
        'vla1-3212.search.yandex.net:27017',
    ]),
    replicaset='heartbeat_mongodb_b',
    read_preference=pymongo.ReadPreference.PRIMARY_PREFERRED
)

ALL_HEARTBEAT_C_MONGODB = MongoStorage(
    uri=','.join([
        'myt0-4012.search.yandex.net:27017',
        'myt0-4019.search.yandex.net:27017',
        'sas1-6063.search.yandex.net:27017',
        'sas1-6136.search.yandex.net:27017',
        'vla1-3984.search.yandex.net:27017',
    ]),
    replicaset='heartbeat_mongodb_c',
    read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED
)

INFRA_MONGODB = MongoStorage(
    uri=','.join([
        'sas1-3155.search.yandex.net:27017',
        'ws30-522.yandex.ru:27017',
        'ws37-915.yandex.ru:27017',
        'ws41-365.yandex.ru:27017',
        'man1-1149.search.yandex.net:27017',
    ]),
    replicaset='autobalancing',
    read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED
)

HEARTBEAT_MONGODB = MongoStorage(
    uri=','.join([
        'hb-dbs01.search.yandex.net:27017',
        'hb-dbs02.search.yandex.net:27017',
        'hb-dbs03.search.yandex.net:27017',
        'hb-dbs04.search.yandex.net:27017',
        'hb-dbs05.search.yandex.net:27017',
    ]),
    replicaset='heartbeat',
    read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED
)
