import pymongo
import datetime as dt


from libraries.hardware import get_hosts_data
from mongo_params import HEARTBEAT_MONGODB


client = pymongo.MongoReplicaSetClient(
    HEARTBEAT_MONGODB.uri,
    replicaSet=HEARTBEAT_MONGODB.replicaset, read_preference=HEARTBEAT_MONGODB.read_preference,
    localThresholdMS=30000,
)
db = client['heartbeat']


def shortname(host):
    return host.replace('.search.yandex.net', '').replace('.yandex.ru', '')


def update_alive():
    #hosts that have NOT been reporting new statuses for one hour considered to be dead
    new_alive = set()
    coll = db['instancestatev3']
    res = coll.find(
        {'last_update': {'$gt': dt.datetime.now() - dt.timedelta(hours=1)}},
        {'host': 1, '_id': 0}
    )
    for r in res:
        new_alive.add(shortname(r['host']))

    coll = db['shardstatev3']
    res = coll.find(
        {'last_update': {'$gt': dt.datetime.now() - dt.timedelta(hours=1)}},
        {'host': 1, '_id': 0}
    )
    for r in res:
        new_alive.add(shortname(r['host']))

    coll = db['hostinfo']
    res = coll.find(
        {'last_update': {'$gt': dt.datetime.now() - dt.timedelta(hours=1)}},
        {'host': 1, '_id': 0}
    )
    for r in res:
        new_alive.add(shortname(r['host']))

    return new_alive


def network(period_in_minutes=2, t='pess'):
    def default_counts():
        return {
            'bb4': {'c': 0, 'p': 0, 'h': set()},
            'bb6': {'c': 0, 'p': 0, 'h': set()},
            'fb6': {'c': 0, 'p': 0, 'h': set()}
        }

    network = {'dcs': {}, 'counts': default_counts()}
    hosts_map = get_hosts_data()

    alive = update_alive()

    for net in ['bb4', 'bb6', 'fb6']:
        res = db['pinger2'].aggregate([
            {"$match": {'generated': {'$gt': dt.datetime.now() - dt.timedelta(minutes=period_in_minutes)},
                        net: {'$exists': 1}}},
            {"$group": {"_id": "$target", net: {"$max": "$" + net}}}
        ])

        for doc in res:
            host = shortname(doc['_id'])

            if host not in alive:
                continue

            try:
                d, l, s = hosts_map[host]
            except KeyError:
                continue

            value = doc[net]
            if isinstance(value, dict):
                value = value['result']

            if d == 'unknown' or len(d) == 0 or value < 0:
                continue

            if t == 'pess':
                p = 1 if value >= 1. else 0
            elif t == 'opt':
                p = 1 if value >= 0.1 else 0
            else:
                p = value

            network['counts'][net]['c'] += 1
            network['counts'][net]['p'] += p

            dc = network['dcs'].setdefault(d, {'lines': {}, 'counts': default_counts()})
            dc['counts'][net]['c'] += 1
            dc['counts'][net]['p'] += p

    return network
