from concurrent.futures import ThreadPoolExecutor

from utils import singleton


class Pool(object):
    def __init__(self, max_workers):
        self.executor = ThreadPoolExecutor(max_workers=max_workers)

    def submit(self, task, *args, **kwargs):
        return self.executor.submit(task, *args, **kwargs)



@singleton
def pool():
    return Pool(max_workers=64)
