from datetime import timedelta, datetime
import httplib


class TimeLimitedCounter(object):
    def __init__(self, delta):
        self.delta = delta
        self.successes = 0
        self.errors = 0

    def __enter__(self):
        self.start = datetime.now()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.finish = datetime.now()

    def valid(self):
        return datetime.now() - self.start < self.delta

    def success(self):
        self.successes += 1

    def error(self):
        self.errors += 1

    def rps(self):
        dt = float((self.finish - self.start).total_seconds())
        return {
            'success': self.successes / dt,
            'error': self.errors / dt
        }


if __name__ == '__main__':
    conn = httplib.HTTPConnection('0.0.0.0', 20213)
    conn.connect()

    with TimeLimitedCounter(delta=timedelta(seconds=10)) as counter:
        while counter.valid():
            # noinspection PyBroadException
            try:
                # resolve('I@testws', force=False)
                conn.request('GET', '/pnetwork?json=yes')
                conn.getresponse().read()
            except Exception as e:
                counter.error()
            else:
                counter.success()

    print counter.rps()
