import logging
from collections import defaultdict
from httplib import HTTPConnection, HTTPException
import time
from urllib import urlencode
import msgpack
import utils

RESOLVER_HOST = 'localhost'
RESOLVER_PORT = 20214


class ResolverServiceProxy(object):
    """Reconnects on any failure."""

    def __init__(self):
        self.conn = None

    def resolve(self, term, force=False):
        if term == '':
            return set(), {}

        for attempt in xrange(3):
            try:
                if self.conn is None:
                    self.conn = HTTPConnection(RESOLVER_HOST, RESOLVER_PORT)
                    self.conn.connect()
                self.conn.request('GET', '/?' + urlencode([('term', term), ('force', force)]))
                hosts, instances = msgpack.load(self.conn.getresponse())
                return norm_hosts(hosts), norm_instances(instances)
            except (IOError, RuntimeError, HTTPException, msgpack.exceptions.UnpackException) as e:
                self.conn = None
                time.sleep(2 ** attempt)
                logging.warning('resolve [%s] attempt %s failed: [%s]', term, attempt, str(e))

        return set(), {}


def reconfigure_resolver(host, port):
    global RESOLVER_HOST, RESOLVER_PORT
    RESOLVER_HOST = host
    RESOLVER_PORT = port


def norm_hosts(hosts):
    return map(utils.shortname, hosts)


def norm_instances(instances):
    norm = defaultdict(dict)
    for host, data in instances.iteritems():
        norm[utils.shortname(host)] = data
    return norm


def resolve(term, force=False):
    return _proxy().resolve(term, force)


@utils.singleton
def _proxy():
    return ResolverServiceProxy()
