import time

import utils

import api.hq as hq


def all_conf(prefix):
    return _cms().all_conf(prefix)


def suggest(term):
    return _cms().suggest(term)


def suggest_no_mainconf(term):
    return _cms().suggest(term)[0]


def update_cache():
    pass


def get_full_instances(conf, instances_filter):
    return dict.fromkeys(instances_filter)


class _CMS(object):
    # returns dict like this {'production_spellchecker_http_man-1513791817836': 1513791840}
    @staticmethod
    def all_conf(prefix):
        service = prefix.rstrip('-')
        now = int(time.time())
        confs = {}
        for instances_on_host in hq.HQResolver(use_service_resolve_policy=True).get_instances(service).itervalues():
            for (_, instance) in instances_on_host:
                confs[instance.split('@')[1]] = now
        return confs

    @staticmethod
    def suggest(term):
        """
        The only suggestable pattern is 'C@family_or_service_name' with possible '-' at the end.
        """
        term = term.strip()
        if ' ' in term or '+' in term:  # compound expression
            return [term], term.split(' ')[0].lstrip('C@')  # nothing to suggest, the first subexpression is the conf

        family = term.rstrip('-')
        if '-' in family or not family.startswith('C@'):
            return [term], term.lstrip('C@')  # nothing to suggest, the expression is the conf

        return hq_suggest(family.lstrip('C@')), 'HEAD'  # suggest confs from hq family, magic 'HEAD' is the conf


def hq_suggest(service):
    family_instances = hq.HQResolver(use_service_resolve_policy=True).get_instances(service)
    confs = set()
    for instances_on_host in family_instances.itervalues():
        for (_, instance) in instances_on_host:
            confs.add('C@' + instance.split('@')[1])
    return list(confs)


@utils.singleton
def _cms():
    return _CMS()
