import argparse
import sys

import log


def main():
    args = parse_args()
    if args.check_hosts:
        log.configure_logging(debug=True, logs_dir=args.logs_dir)

        import libraries.hardware
        libraries.hardware.load_singletons()

        import suspension_api
        suspension_api.check(args.check_hosts.split(','))
        return

    if args.update_suspension:
        log.configure_logging(debug=True, logs_dir=args.logs_dir)

        import libraries.hardware
        libraries.hardware.load_singletons()

        import suspension_api
        suspension_api.update_status_loop()
        return

    log.configure_logging(debug=args.debug, logs_dir=args.logs_dir)

    if args.resolve_term:
        import resolver_web_gevent
        sys.stdout.write(resolver_web_gevent.main_term(args.resolve_term))
        return

    if args.resolver:
        import resolver_web_gevent
        resolver_web_gevent.main_web(args.port)

    else:
        import blinov
        blinov.reconfigure_resolver('localhost', args.resolver_port)

        import libraries.hardware
        libraries.hardware.load_singletons()

        import web
        web.Web(args.port, args.warmup).start()


def parse_args():
    parser = argparse.ArgumentParser(description='Clusterstate web server')
    parser.add_argument('-p', '--port', default=20213, type=int, help='listen port')
    parser.add_argument('--warmup', dest='warmup', action='store_true', help='[default] warm up before port opening')
    parser.add_argument('--no-warmup', dest='warmup', action='store_false', help="don't warm up")
    parser.add_argument('--debug', dest='debug', default=False, action='store_true', help='fancy logging to stdout')
    parser.add_argument('--resolver-port', dest='resolver_port', default=20214, help='local resolver port')
    parser.add_argument('--resolver', default=False, action='store_true', help='run local resolver')
    parser.add_argument('--resolve-term', default=None, type=str, help='resolve single term')
    parser.add_argument('--check-hosts', default=None, type=str, help='check suspension possibility; comma separated')
    parser.add_argument('--update-suspension', action='store_true', help='run suspension update loop')
    parser.add_argument('--logs-dir', default='./logs')
    parser.set_defaults(warmup=True)
    return parser.parse_args()
