import argparse

import blinov
import log
# import web


def main():
    args = parse_args()
    log.configure_logging(debug=args.debug)

    blinov.reconfigure_resolver('localhost', args.resolver_port)

    # web.Web(args.port, args.warmup).start()


def parse_args():
    parser = argparse.ArgumentParser(description='Clusterstate web server')
    parser.add_argument('-p', '--port', default=20213, help='listen port')
    parser.add_argument('--warmup', dest='warmup', action='store_true', help='[default] warm up before port opening')
    parser.add_argument('--no-warmup', dest='warmup', action='store_false', help="don't warm up")
    parser.add_argument('--debug', dest='debug', default=False, action='store_true', help='fancy logging to stdout')
    parser.add_argument('--resolver-port', dest='resolver_port', default=20214, help='local resolver port')
    parser.set_defaults(warmup=True)
    return parser.parse_args()
