import datetime
import functools
import logging
import math
import random
import socket
import threading
import time
import uuid

import kernel.util.functional as kernel


singleton = kernel.singleton
memoized = kernel.memoized


def run_daemon(target, args=()):
    t = threading.Thread(target=target, args=args)
    t.daemon = True
    t.start()


def shortname(host):
    return host.replace('.search.yandex.net', '').replace('.yandex.ru', '')


def logtime(fn):
    def exec_time(start_time):
        return str(math.trunc((time.time() - start_time) * 1000) / 1000.) + 's'

    @functools.wraps(fn)
    def inner(*args, **kwargs):
        stime = time.time()
        retval = fn(*args, **kwargs)
        args[0].log.info('{0}: {1}'.format(fn.__name__, exec_time(stime)))
        return retval

    return inner


def run_daemon_loop(func, sleep_interval=60):
    def fn():
        while True:
            try:
                func()

            except Exception as e:
                logging.error(e)

            time.sleep(sleep_interval)

    run_daemon(fn)


def genuuid():
    return str(uuid.UUID(int=random.getrandbits(128)))


def timestamp(t):
    return (t - datetime.datetime(1970, 1, 1)).total_seconds()


@singleton
def fqdn():
    return socket.getfqdn()
