import pymongo
from collections import namedtuple

MongoStorage = namedtuple('MongoStorage', ['uri', 'replicaset', 'read_preference'])

HEARTBEAT_MONGODB = MongoStorage(
    uri=','.join([
        'hb-dbs01.search.yandex.net:27017',
        'hb-dbs02.search.yandex.net:27017',
        'hb-dbs03.search.yandex.net:27017',
        'hb-dbs04.search.yandex.net:27017',
        'hb-dbs05.search.yandex.net:27017',
    ]),
    replicaset='heartbeat',
    read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED
)
