import flask

from updaters import updater
from web import app

from libraries.topology.search_map import load_subs, get_search_map
from libraries.topology.utils import tag_to_version, version_to_tag
from libraries.utils import shortname


def group_of_instance(tag, host, port):
    host = shortname(host)
    if host in updater.hosts:
        instance = '{}:{}'.format(host, port)
        if instance in updater.hosts[host]['i']:
            return {'name': updater.hosts[host]['i'][instance]['tg'],
                    'version': tag_to_version(tag)}


def list_subs(host, port, tag, direction):
    commit = updater.tags[tag]['commit']
    lst = load_subs(commit, host, port, direction)
    res = []
    for one in lst:
        host_, _, port_ = one.partition(':')
        port_ = int(port_)
        doc = {'host': host_, 'port': port_, 'group': group_of_instance(tag, host_, port_)}
        res.append(doc)
    return res


@app.route('/tags/<tag>/search_map/host/<host>/port/<port>/<direction>')
def api_get_search_map(tag, host, port, direction):
    assert direction in ('up', 'down')

    res = list_subs(host, port, tag, direction)
    return flask.jsonify({direction: res})


@app.route('/tags/<tag>/search_map/<group>/<direction>')
def api_get_search_map_by_group(tag, group, direction):
    assert direction in ('up', 'down')
    commit = updater.tags[tag]['commit']
    res = get_search_map(commit, group, direction)
    if res is not None:
        return flask.jsonify(res)
    return flask.Response('not found', status=404)


@app.route('/search_map/host/<host>/port/<port>/<direction>')
def api_get_search_map_no_tag(host, port, direction):
    assert direction in ('up', 'down')

    version = _get_online_group_version(host, port)
    tag = version_to_tag(version)
    res = list_subs(host, port, tag, direction)
    return flask.jsonify({direction: res})


def _get_online_group_version(host, port):
    host = shortname(host)
    instance = '{}:{}'.format(host, port)

    return updater.hosts[host]['i'][instance]['tv']


def _is_alive(total_count, alive_count):
    return alive_count > DEAD_GROUP_THRESHOLD * total_count


DEAD_GROUP_THRESHOLD = 0.05
