import gevent
import logging
import pymongo.errors
from libraries.containers import mongo


class ReportsController(gevent.Greenlet):
    _sleep_time = 5
    _logger = logging.getLogger('reports')

    def __init__(self):
        super(ReportsController, self).__init__()
        self._containers = []

    def consume_container(self, container):
        self._containers.append(container)

    def _report_all(self):
        containers = self._containers
        self._containers = []
        if containers:
            self._logger.info('got %i reports, inserting', len(containers))
            bulk = mongo.containers().initialize_unordered_bulk_op()
            for one in containers:
                bulk.find({'name': one.name}).upsert().replace_one(one.json())
            try:
                bulk.execute({'w': 2, 'wtimeout': 5 * 1000})
            except pymongo.errors.BulkWriteError as ex:
                self._logger.error(ex)
        else:
            self._logger.info('got no reports')

    def _run(self):
        while True:
            try:
                self._report_all()
            except Exception as ex:
                self._logger.error(ex)
            finally:
                gevent.sleep(self._sleep_time)
