

def find_group(groups_state, group):
    versions = []
    for version, group_state in groups_state.group_versions(group).iteritems():
        group_state.recalc_cnt()
        total = group_state.all_instances_cnt()
        alive = group_state.alive_instances_cnt()
        if alive > total * 0.90 and alive > 10:
            return group, version
        versions.append((group, version, alive / float(total)))
    if not versions:
        return group, None
    return sorted(versions, key=lambda x: x[2], reverse=True)[0][:2]
