import flask
import jinja2
import datetime

from gui import gui_bp, load_template_from_resources
from limits.limits_info import limits_info_bp
from limits.configs import configs_bp
from containers.containers_api import containers_bp
from containers.reports import report_bp
from containers.solomon import solomon_bp
from control import control_bp


app = flask.Flask(__name__)

app.register_blueprint(containers_bp, url_prefix='/containers')
app.register_blueprint(control_bp, url_prefix='/control')
app.register_blueprint(limits_info_bp)
app.register_blueprint(configs_bp)
app.register_blueprint(report_bp)
app.register_blueprint(solomon_bp, url_prefix='/solomon')
app.register_blueprint(gui_bp)


@app.template_filter('days_remain')
def _template_filter_days_remain(date):
    diff = date - datetime.datetime.now()
    return '{} days'.format(diff.days)


@app.template_filter('strftime')
def _template_filter_datetime(date):
    return date.strftime('%Y-%m-%d %H:%M')


@app.template_filter('shortname')
def _template_filter_shortname(host):
    return host.replace('.search.yandex.net', '')


from gui.control import vm_url, host_url, cluster_url


app.template_filter('vm_url')(vm_url)
app.template_filter('host_url')(host_url)
app.template_filter('cluster_url')(cluster_url)


app.jinja_env.loader = jinja2.FunctionLoader(load_template_from_resources)
