import json
import flask
import datetime
from libraries.containers import Container
from libraries.utils import shortname
from updaters import updater


report_bp = flask.blueprints.Blueprint(__name__, 'reports')


@report_bp.route('/report', methods=['POST'])
def api_report_handler_v2():
    containers = json.loads(flask.request.data)['containers']
    for cont in containers:
        cont['reported_at'] = datetime.datetime.now()
        if 'mode' not in cont or 'name' not in cont:
            cont['mode'] = 'os'
            cont['name'] = cont['dns_name']
        if cont['mode'] == 'app':
            cont['name'] = '{}-{}'.format(shortname(cont['host']), cont['name'])
        cont = Container.fabric(**cont)
        updater().report_ctrl.consume_container(cont)
    return flask.jsonify({'success': 1})
