import flask
import datetime
from libraries.containers import Container
from ..util import split_hosts_to_states
from updaters import updater


solomon_bp = flask.blueprints.Blueprint(__name__, 'solomon')


@solomon_bp.route('/<cluster>/hosts')
def api_solomon_cluster_hosts(cluster):
    lst = Container.list({
        'reported_at': {'$gte': datetime.datetime.now() - datetime.timedelta(minutes=2)},
        'cluster': cluster
    })
    lst = [one.host for one in lst]
    res = '\n'.join(lst)
    return flask.Response(res, headers={'content-type': 'text'})


@solomon_bp.route('/sas_xcalc/hosts')
def api_solomon_cluster_hosts_fake1():
    return api_solomon_cluster_hosts('xcalc')


@solomon_bp.route('/sas_xcalc/status')
def api_solomon_cluster_hosts_fake2():
    return api_solomon_cluster_status('xcalc')


@solomon_bp.route('/rotor/status')
def api_solomon_cluster_hosts_fake3():
    return api_solomon_cluster_status('rotor')


@solomon_bp.route('/<cluster>/status')
def api_solomon_cluster_status(cluster):
    if cluster not in updater().clusters:
        return flask.Response(status=404)
    res = split_hosts_to_states(cluster)

    return flask.jsonify({
        'sensors': [
            {'labels': {'sensor': key}, 'value': len(res[key])}
            for key in res
        ]
    })
