import os

import flask
import library.python.resource as resource

import cpu_map
import control


def load_template_from_resources(path):
    return resource.find(os.path.join('/templates', path))


def load_static_from_resources(path):
    return resource.find(os.path.join('/static', path))


gui_bp = flask.Blueprint(__name__, 'gui')

cpu_map.register_handlers(gui_bp)
control.register_handlers(gui_bp)


@gui_bp.route('/gui/static/<path:path>', methods=['GET'])
def static_proxy(path):
    return flask.Response(load_static_from_resources(path), mimetype='text/css')
