import flask
from util import get_limits, get_resources, calc_available_resources


limits_info_bp = flask.Blueprint(__name__, 'limits_info')


@limits_info_bp.route('/limits_info/<host>')
def api_limits_info_handler(host):
    compact = flask.request.args.get('compact', '0') == '1'
    res, info = get_limits(host, calc_info=not compact)
    res = calc_available_resources(res, get_resources(host), host)
    return flask.jsonify({'sum': res, 'info': info})
