PY2_PROGRAM()

PEERDIR(
    contrib/python/Flask
    library/python/resource

    infra/clusterstate/libraries
)

PY_MAIN(main)

PY_SRCS(
    TOP_LEVEL

    web/__init__.py
    web/containers/__init__.py
    web/containers/reports/__init__.py
    web/containers/solomon/__init__.py
    web/containers/containers_api.py
    web/containers/util.py

    web/control/__init__.py

    web/gui/__init__.py
    web/gui/control.py
    web/gui/cpu_map.py

    web/limits/__init__.py
    web/limits/configs.py
    web/limits/limits_info.py
    web/limits/util.py

    main.py
    reports_ctrl.py
    settings.py
    updaters.py
    utils.py
)

RESOURCE(
    web/gui/static/css/control.css /static/css/control.css
    web/gui/static/css/heatmap.css /static/css/heatmap.css
    web/gui/static/css/milligram.css /static/css/milligram.css

    web/gui/templates/base.html /templates/base.html
    web/gui/templates/cluster-list.html /templates/cluster-list.html
    web/gui/templates/heatmap.html /templates/heatmap.html
    web/gui/templates/host.html /templates/host.html
    web/gui/templates/on-demand-cluster.html /templates/on-demand-cluster.html
    web/gui/templates/vm.html /templates/vm.html
)

OWNER(cerg1168 okats)

END()
