from utils import configure_log
from service import Service


def main():
    args = parse_args()
    configure_log(debug=args.debug, beta=args.beta)

    Service(args.port).start()


def parse_args():
    import argparse

    parser = argparse.ArgumentParser(description='Clusterstate resolver service')
    parser.add_argument('-p', '--port', default=20215, help='listen port')
    parser.add_argument('--warmup', dest='warmup', action='store_true', help='[default] warm up before port opening')
    parser.add_argument('--no-warmup', dest='warmup', action='store_false', help="don't warm up")
    parser.add_argument('--debug', dest='debug', default=False, action='store_true', help='enable fancy logging to stdout')
    parser.add_argument('--beta', dest='beta', default=False, action='store_true', help='run as beta (affects logging)')
    parser.set_defaults(warmup=True)
    return parser.parse_args()


if __name__ == '__main__':
    main()
