import datetime

import pymongo

import libraries.mongo_params as mongo_params
import libraries.online_state as online_state
import libraries.utils


def get_mongo_client():
    return pymongo.MongoReplicaSetClient(
        mongo_params.HEARTBEAT_MONGODB.uri,
        replicaSet=mongo_params.HEARTBEAT_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=mongo_params.HEARTBEAT_MONGODB.read_preference,
    )


def alive_hosts():
    alive = set()
    db = get_mongo_client()['heartbeat']
    for rec in db['hostinfo'].find(
        {'last_update': {'$gt': datetime.datetime.now() - datetime.timedelta(hours=4)}},
        {'host': 1, '_id': 0}
    ):
        alive.add(libraries.utils.shortname(rec['host']))
    return alive


def get_groups_state():
    db = get_mongo_client()['heartbeat']
    instance_state = online_state.InstanceState()
    instance_state.update(alive_hosts(), db)

    for group in instance_state.groups_state.groups():
        for state in instance_state.groups_state.group_versions(group).values():
            state.recalc_cnt()

    return instance_state.groups_state
