state_keys = ('a', 'as', 'cs', 'ct', 'ds', 'i', 'is', 'sv', 'ts', 'z')

longname_key_map = {
    'acquired': 'a',
    'aspam_mtime': 'sv',
    'downloaded': 'ds',
    'indexarc_size': 'as',
    'indexinv_size': 'is',
    'installed': 'i',
    'mtime': 'ct',
    'search_zone': 'z',
    'shard_int_md5': 'cs',
    'total': 'ts',
}

istate_keys = ('a', 'md5', 'mu', 'mv', 'p', 'r', 's', 'u', 'c', 't', 'st', 'res', 'tg', 'tv')

ilongname_key_map = {
    'alive': 'a',
    'binary_md5': 'md5',
    'binary_revision': 'r',
    'models_md5': 'mv',
    'prepared': 'p',
    'shard': 's',
    'supermind': 'mu',
    'svn_url': 'u',
    'cgroups': 'c',
    'itype': 't',
    'sandbox_task': 'st',
    'other_resources': 'res',
    'group_from_tag': 'tg',
    'version_from_tag': 'tv',
}


class StateV3(object):
    __slots__ = state_keys

    def __init__(self, state):
        for key in state_keys:
            realkey = longname_key_map.get(key, key)
            setattr(self, key, state.get(realkey, None))

    def __getitem__(self, key):
        try:
            return getattr(self, key)
        except AttributeError:
            raise KeyError(key)

    def __contains__(self, key):
        try:
            self.__getitem__(key)
            return True
        except KeyError:
            return False

    def __repr__(self):
        res = []
        for key in sorted(self.__slots__):
            value = getattr(self, key, None)
            if value is not None:
                res.append(key + ': ' + str(value))
        return '<%s object at 0x%x {%s}>' % (self.__class__.__name__, id(self), ', '.join(res))

    def get(self, key, default):
        try:
            return getattr(self, key)
        except AttributeError:
            return default


class IStateV3(object):
    __slots__ = istate_keys

    def __init__(self, state):
        for key in istate_keys:
            realkey = ilongname_key_map.get(key, key)
            setattr(self, key, state.get(realkey, None))

    def __getitem__(self, key):
        try:
            return getattr(self, key)
        except AttributeError:
            raise KeyError(key)

    def __contains__(self, key):
        try:
            self.__getitem__(key)
            return True
        except KeyError:
            return False

    def __repr__(self):
        res = []
        for key in sorted(self.__slots__):
            value = getattr(self, key, None)
            if value is not None:
                res.append(key + ': ' + str(value))
        return '<%s object at 0x%x {%s}>' % (self.__class__.__name__, id(self), ', '.join(res))

    def get(self, key, default):
        try:
            return getattr(self, key)
        except AttributeError:
            return default
