

function generateXYpars(outerWidth, outerHeight, margin) {
    var width = outerWidth - margin.left - margin.right,
        height = outerHeight - margin.top - margin.bottom;

    var x = function (d) {
        return d['data'][0]
    };
    var y = function (d) {
        return d['data'][1]
    };
    var xs = d3.scale.linear()
        .range([0, width]).nice();

    var ys = d3.scale.linear()
        .range([height, 0]).nice();

    return [width, height, x, y, xs, ys];
}


function quantile(data, p, getter) {
    var temp = [];
    for (var i in data) {
        temp.push(getter(data[i]))
    }
    temp = temp.sort(function(a, b) {
        return (a + 0.0) > (b + 0.0);
    });
    return d3.quantile(temp, p);
}

function generateAxis(svg, data, x, y, xs, ys, width, height, min_0, is_monitor) {
    var xMax = d3.max(data, function (d) {
            return x(d);
        }),
        xMin = d3.min(data, function (d) {
            return x(d);
        }),
        xMin = min_0 ? 0 : xMin * 0.95,
        yMax = d3.max(data, function (d) {
            return y(d);
        }),
        yMin = d3.min(data, function (d) {
            return y(d);
        }),
        yMin = min_0 ? 0 : yMin * 0.95,
        xMax = xMax > 21 && is_monitor ? quantile(data, 0.99, x) * 1.05 : xMax * 1.05,
        yMax = yMax > 65 && is_monitor ? quantile(data, 0.99, y) * 1.05 : yMax * 1.05;

    xs.domain([xMin, xMax]);
    ys.domain([yMin, yMax]);

    var xAxis = d3.svg.axis()
        .scale(xs)
        .orient("bottom")
        .tickSize(-height);
    var yAxis = d3.svg.axis()
        .scale(ys)
        .orient("left")
        .tickSize(-width);
    var tip = d3.tip()
        .attr("class", "d3-tip")
        .offset([-10, 0])
        .html(function (d) {
            return d['name'] + '<br>50%: ' + x(d).toFixed(2) + '<br>90%: ' + y(d).toFixed(2) +
                '<br> times: ' + d['times'];
        });

    function transform(d) {
        return "translate(" + xs(x(d)) + "," + ys(y(d)) + ")";
    }
    function zoom() {
        svg.select(".x.axis").call(xAxis);
        svg.select(".y.axis").call(yAxis);
        svg.selectAll(".dot")
            .attr("transform", transform);
    }
    var zoomBeh = d3.behavior.zoom()
        .x(xs)
        .y(ys)
        .scaleExtent([0, 20])
        .on("zoom", zoom);

    svg.call(zoomBeh);

    return [xAxis, yAxis, transform, tip];
}


function draw(plots, outerWidth, outerHeight, margin, is_monitor) {
    function draw_plot(name) {
        var svg = d3.select('#' + name)
            .attr("width", outerWidth)
            .attr("height", outerHeight)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        var data = plots[name]['ok'].concat(plots[name]['out']);
        var [width, height, x, y, xs, ys] = generateXYpars(outerWidth, outerHeight, margin);
        var [xAxis, yAxis, transform, tip] = generateAxis(svg, data, x, y, xs, ys, width, height, false, is_monitor);

        svg.call(tip);

        svg.append("rect")
            .attr("width", width)
            .attr("height", height);
        svg.append("g")
            .classed("x axis", true)
            .attr("transform", "translate(0," + height + ")")
            .call(xAxis);
        svg.append("g")
            .classed("y axis", true)
            .call(yAxis);

        function create_objects(name, cls) {
            data = plots[name][cls];
            return svg.append("svg")
                .classed(name + cls, true)
                .attr("width", width)
                .attr("height", height)
                .selectAll(".dot")
                .data(data)
                .enter().append("circle")
                .classed("dot", true)
                .attr("r", function (d) {
                    return 3 + (d['times'] || 0) / 2;
                })
                .attr("transform", transform);
        }

        create_objects(name, 'ok')
            .style("fill", function (d) {
                return plots[name]['color']
            });

        create_objects(name, 'out')
            .style("fill", function (d) {
                return 'red'
            })
            .on("mouseover", tip.show)
            .on("mouseout", tip.hide);
    }

    function draw_all(names) {
        var data = [];
        names.forEach(function (item, i, names) {
            data = data.concat(plots[item]['ok']).concat(plots[item]['out']);
        });

        var svg = d3.select('#all')
            .attr("width", outerWidth)
            .attr("height", outerHeight)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        var [width, height, x, y, xs, ys] = generateXYpars(outerWidth, outerHeight, margin);
        var [xAxis, yAxis, transform] = generateAxis(svg, data, x, y, xs, ys, width, height, true, is_monitor);

        svg.append("rect")
            .attr("width", width)
            .attr("height", height);
        svg.append("g")
            .classed("x axis", true)
            .attr("transform", "translate(0," + height + ")")
            .call(xAxis);
        svg.append("g")
            .classed("y axis", true)
            .call(yAxis);

        names.forEach(function (name, i, names) {
            var objects = svg.append("svg")
                .classed('all', true)
                .attr("width", width)
                .attr("height", height);
            data = plots[name]['ok'].concat(plots[name]['out']);
            objects.selectAll(".dot")
                .data(data)
                .enter().append("circle")
                .classed("dot", true)
                .attr("r", function (d) {
                    return 3;
                })
                .attr("transform", transform)
                .style("fill", function (d) {
                    return plots[name]['color']
                });
        });
    }

    var names = [];
    for (var name in plots) names.push(name);
    draw_all(names);
    for (var key in plots) {
        draw_plot(key);
    }
}


function update_plots(plots, outerWidth, outerHeight, margin, is_monitor) {
    var names = [];
    for (var name in plots) names.push(name);
    for (var key in plots) {
        d3.select("#" + key).selectAll('*').remove();
    }
    d3.selectAll('.d3-tip').remove();
    d3.select("#" + 'all').selectAll('*').remove();
    draw(plots, outerWidth, outerHeight, margin, is_monitor);
}
