from datetime import datetime, timedelta
import pymongo
import msgpack

from mongo_params import HEARTBEAT_MONGODB


def get_mongo_client():
    return pymongo.MongoClient(
        HEARTBEAT_MONGODB.uri,
        replicaSet=HEARTBEAT_MONGODB.replicaset,
        read_preference=HEARTBEAT_MONGODB.read_preference,
        localThresholdMS=30000,
    )


client = get_mongo_client()
db = client['heartbeat']
timestamp = datetime.now() - timedelta(hours=1)

interested_itypes = {}

for r in db['instancestatev3'].find(
        {'last_update': {'$gt': timestamp}},
        {'host': 1, '_id': 0, 'state': 1, 'last_update': 1}
):
    state = msgpack.loads(r['state'])

    try:
        for k, v in state['i'].iteritems():
            if 'md5' in v:
                for p in v['tags'].split(' '):
                    if p.startswith('a_itype_'):
                        interested_itypes.setdefault(p, k)
    except KeyError:
        pass

print interested_itypes
