import os

from states import states
import pprint


def main():
    groups = {}
    f = open(os.path.join(os.path.dirname(__file__), 'basesearch_groups'), 'r')
    for g in f.readlines():
        group = g.strip().split('\t')[0]
        tags = g.strip().split('\t')[1].split(',')
        groups.setdefault(group, {'tags': tags, 'versions': {}})

    states().update_alive()
    states().update_istates()

    for h, data in states().istates().iteritems():
        for iname, idata in data['i'].iteritems():
            group = idata['tg']
            if group not in groups:
                continue

            version = idata['r']
            svnurl = strip_url(idata['u'])

            key = (version, svnurl)
            groups[group]['versions'].setdefault(key, 0)
            groups[group]['versions'][key] += 1

    pprint.pprint(groups)


def strip_url(url):
    if not url:
        return url

    if 'arcadia.yandex.ru/arc/' in url:
        return url.split('arcadia.yandex.ru/arc/')[1].split('/arcadia')[0]

    return url


if __name__ == '__main__':
    main()
