import requests
import subprocess


def load_7z_files(file_name):
    p = subprocess.Popen('7zr l {}'.format(file_name), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    out, _ = p.communicate()

    files = set()
    for line in out.splitlines():
        files.add(line.split('/')[-1])

    return files


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(description='check searcherlookup')
    parser.add_argument('-f', dest='file_name')
    parser.add_argument('-t', dest='gencfg_tag')
    parser.add_argument('-g', dest='groups')
    return parser.parse_args()


def main():
    args = parse_args()

    files = load_7z_files(args.file_name)

    for group in args.groups.split(','):
        print 'Checking group: {0}'.format(group)

        url = 'http://api.gencfg.yandex-team.ru/{0}/groups/{1}/instances'.format(args.gencfg_tag, group)
        r = requests.get(url)
        instances = r.json()['instances']

        for i in instances:
            config_name = '{0}:{1}.cfg'.format(i['hostname'].split('.')[0], i['port'])
            if config_name not in files:
                print '{0}: config {1} not found!'.format(group, config_name)


if __name__ == '__main__':
    main()
