import time
import logging

from libraries.topology.mongo import tags, searcher_lookup, groups
from libraries.utils import memoize


@memoize
def good_tags():
    good = set()
    for tag in tags().find({'fullstate': 1}):
        good.add(tag['tag'])
    return frozenset(good)


@memoize
def all_tags():
    all_tags_ = set()
    for tag in tags().find({
        'commit': {
            '$lt': tag_to_commit()['stable-100-r1']
        }
    }):
        all_tags_.add(tag['tag'])
    return frozenset(all_tags_)


BAD_TAGS = frozenset([u'stable-93-r63', u'stable-88-r75', u'stable-90-r39', u'stable-90-r4', u'stable-93-r170', u'stable-99-r190', u'stable-95-r54', u'stable-99-r50', u'stable-90-r6', u'stable-98-r90', u'stable-98-r91', u'stable-93-r151', u'stable-94-r39', u'stable-97-r88', u'stable-97-r89', u'stable-93-r155', u'stable-93-r154', u'stable-93-r157', u'stable-97-r29', u'stable-94-r30', u'stable-94-r31', u'stable-94-r32', u'stable-97-r81', u'stable-94-r34', u'stable-94-r35', u'stable-94-r36', u'stable-97-r85', u'stable-93-r93', u'stable-96-r9', u'stable-90-r2', u'stable-90-r37', u'stable-90-r3', u'stable-94-r48', u'stable-94-r100', u'stable-94-r58', u'stable-98-r79', u'stable-94-r59', u'stable-93-r176', u'stable-94-r56', u'stable-95-r52', u'stable-95-r45', u'stable-97-r21', u'stable-94-r122', u'stable-91-r28', u'stable-94-r25', u'stable-97-r23', u'stable-93-r79', u'stable-93-r78', u'stable-93-r77', u'stable-94-r52', u'stable-93-r75', u'stable-93-r74', u'stable-93-r73', u'stable-93-r72', u'stable-93-r71', u'stable-97-r25', u'stable-91-r31', u'stable-91-r30', u'stable-91-r33', u'stable-91-r32', u'stable-91-r35', u'stable-91-r34', u'stable-91-r37', u'stable-91-r36', u'stable-91-r39', u'stable-91-r38', u'stable-97-r35', u'stable-97-r34', u'stable-97-r33', u'stable-97-r32', u'stable-97-r31', u'stable-97-r30', u'stable-93-r116', u'stable-93-r174', u'stable-93-r125', u'stable-97-r84', u'stable-94-r45', u'stable-96-r84', u'stable-92-r83', u'stable-92-r82', u'stable-96-r49', u'stable-96-r48', u'stable-92-r87', u'stable-92-r86', u'stable-92-r85', u'stable-92-r84', u'stable-96-r43', u'stable-96-r42', u'stable-96-r41', u'stable-96-r40', u'stable-96-r47', u'stable-96-r46', u'stable-96-r45', u'stable-96-r44', u'stable-94-r44', u'stable-89-r6', u'stable-90-r13', u'stable-94-r139', u'stable-88-r11', u'stable-90-r40', u'stable-88-r13', u'stable-90-r42', u'stable-90-r45', u'stable-90-r44', u'stable-90-r47', u'stable-90-r46', u'stable-90-r49', u'stable-90-r48', u'stable-94-r109', u'stable-93-r153', u'stable-92-r116', u'stable-92-r117', u'stable-92-r114', u'stable-92-r115', u'stable-92-r112', u'stable-92-r113', u'stable-92-r110', u'stable-92-r111', u'stable-97-r191', u'stable-92-r118', u'stable-92-r119', u'stable-97-r93', u'stable-97-r119', u'stable-93-r187', u'stable-93-r156', u'stable-93-r184', u'stable-90-r26', u'stable-92-r14', u'stable-92-r15', u'stable-92-r16', u'stable-92-r17', u'stable-92-r10', u'stable-92-r11', u'stable-97-r100', u'stable-92-r13', u'stable-93-r182', u'stable-92-r18', u'stable-92-r19', u'stable-93-r183', u'stable-99-r117', u'stable-94-r33', u'stable-99-r146', u'stable-93-r180', u'stable-97-r86', u'stable-93-r181', u'stable-97-r87', u'stable-94-r176', u'stable-95-r6', u'stable-95-r5', u'stable-94-r175', u'stable-93-r191', u'stable-93-r190', u'stable-94-r170', u'stable-94-r171', u'stable-99-r37', u'stable-96-r62', u'stable-93-r82', u'stable-97-r95', u'stable-94-r178', u'stable-95-r8', u'stable-99-r135', u'stable-99-r134', u'stable-89-r56', u'stable-99-r136', u'stable-89-r50', u'stable-99-r130', u'stable-89-r52', u'stable-89-r53', u'stable-95-r48', u'stable-95-r49', u'stable-99-r139', u'stable-99-r138', u'stable-99-r35', u'stable-98-r49', u'stable-98-r48', u'stable-93-r188', u'stable-98-r41', u'stable-98-r40', u'stable-98-r43', u'stable-98-r42', u'stable-98-r45', u'stable-99-r126', u'stable-98-r47', u'stable-98-r46', u'stable-97-r64', u'stable-97-r65', u'stable-97-r66', u'stable-97-r67', u'stable-97-r60', u'stable-97-r61', u'stable-97-r62', u'stable-97-r63', u'stable-93-r103', u'stable-97-r68', u'stable-99-r124', u'stable-88-r9', u'stable-88-r8', u'stable-89-r48', u'stable-90-r8', u'stable-90-r9', u'stable-88-r1', u'stable-90-r5', u'stable-88-r3', u'stable-88-r2', u'stable-88-r5', u'stable-88-r4', u'stable-88-r7', u'stable-88-r6', u'stable-93-r128', u'stable-93-r129', u'stable-95-r53', u'stable-99-r120', u'stable-91-r55', u'stable-93-r121', u'stable-93-r122', u'stable-93-r123', u'stable-93-r124', u'stable-94-r152', u'stable-93-r126', u'stable-93-r127', u'stable-95-r35', u'stable-95-r34', u'stable-95-r37', u'stable-95-r36', u'stable-95-r31', u'stable-95-r30', u'stable-95-r33', u'stable-95-r32', u'stable-99-r180', u'stable-99-r182', u'stable-99-r183', u'stable-95-r39', u'stable-95-r38', u'stable-99-r186', u'stable-99-r187', u'stable-94-r129', u'stable-95-r47', u'stable-89-r40', u'stable-99-r119', u'stable-99-r16', u'stable-89-r47', u'stable-90-r29', u'stable-94-r159', u'stable-89-r46', u'stable-94-r111', u'stable-94-r158', u'stable-99-r14', u'stable-89-r45', u'stable-99-r116', u'stable-98-r27', u'stable-99-r143', u'stable-89-r44', u'stable-99-r115', u'stable-89-r55', u'stable-98-r26', u'stable-99-r114', u'stable-98-r25', u'stable-88-r49', u'stable-97-r106', u'stable-99-r10', u'stable-97-r107', u'stable-93-r24', u'stable-93-r25', u'stable-93-r26', u'stable-93-r27', u'stable-93-r20', u'stable-93-r21', u'stable-93-r22', u'stable-93-r23', u'stable-97-r105', u'stable-93-r28', u'stable-93-r29', u'stable-93-r18', u'stable-88-r70', u'stable-88-r46', u'stable-91-r45', u'stable-94-r125', u'stable-93-r186', u'stable-99-r189', u'stable-89-r3', u'stable-99-r123', u'stable-90-r25', u'stable-93-r14', u'stable-90-r24', u'stable-98-r23', u'stable-93-r17', u'stable-94-r96', u'stable-92-r58', u'stable-92-r59', u'stable-93-r16', u'stable-88-r47', u'stable-89-r51', u'stable-94-r172', u'stable-97-r167', u'stable-92-r51', u'stable-92-r52', u'stable-92-r53', u'stable-92-r54', u'stable-92-r55', u'stable-92-r56', u'stable-92-r57', u'stable-93-r175', u'stable-97-r130', u'stable-99-r31', u'stable-97-r118', u'stable-99-r140', u'stable-97-r136', u'stable-98-r16', u'stable-98-r17', u'stable-99-r28', u'stable-98-r15', u'stable-94-r173', u'stable-98-r13', u'stable-88-r48', u'stable-98-r11', u'stable-99-r22', u'stable-99-r23', u'stable-99-r20', u'stable-99-r21', u'stable-99-r26', u'stable-99-r27', u'stable-99-r24', u'stable-88-r41', u'stable-97-r124', u'stable-99-r178', u'stable-97-r126', u'stable-97-r120', u'stable-97-r121', u'stable-97-r122', u'stable-97-r123', u'stable-99-r171', u'stable-99-r170', u'stable-99-r173', u'stable-99-r172', u'stable-97-r128', u'stable-97-r129', u'stable-99-r177', u'stable-99-r176', u'stable-88-r14', u'stable-98-r21', u'stable-95-r50', u'stable-97-r161', u'stable-99-r66', u'stable-99-r33', u'stable-92-r29', u'stable-92-r28', u'stable-97-r72', u'stable-92-r25', u'stable-92-r24', u'stable-92-r27', u'stable-92-r26', u'stable-92-r21', u'stable-92-r20', u'stable-92-r23', u'stable-92-r22', u'stable-88-r17', u'stable-98-r20', u'stable-88-r39', u'stable-88-r38', u'stable-99-r32', u'stable-97-r76', u'stable-93-r168', u'stable-93-r169', u'stable-99-r99', u'stable-99-r98', u'stable-99-r97', u'stable-99-r96', u'stable-99-r95', u'stable-99-r94', u'stable-99-r93', u'stable-99-r92', u'stable-99-r91', u'stable-99-r90', u'stable-93-r108', u'stable-94-r118', u'stable-98-r18', u'stable-89-r65', u'stable-97-r163', u'stable-88-r74', u'stable-89-r66', u'stable-89-r61', u'stable-89-r60', u'stable-89-r63', u'stable-89-r62', u'stable-94-r134', u'stable-98-r22', u'stable-88-r31', u'stable-93-r76', u'stable-88-r30', u'stable-94-r128', u'stable-93-r109', u'stable-96-r100', u'stable-97-r59', u'stable-97-r58', u'stable-97-r164', u'stable-99-r65', u'stable-97-r54', u'stable-97-r57', u'stable-97-r56', u'stable-97-r51', u'stable-97-r50', u'stable-97-r53', u'stable-97-r52', u'stable-99-r142', u'stable-88-r53', u'stable-92-r39', u'stable-93-r106', u'stable-93-r68', u'stable-99-r122', u'stable-97-r94', u'stable-97-r165', u'stable-99-r62', u'stable-93-r60', u'stable-93-r61', u'stable-93-r162', u'stable-93-r64', u'stable-93-r65', u'stable-93-r66', u'stable-93-r67', u'stable-91-r22', u'stable-91-r23', u'stable-91-r20', u'stable-91-r21', u'stable-91-r26', u'stable-91-r27', u'stable-91-r24', u'stable-91-r25', u'stable-97-r20', u'stable-94-r57', u'stable-97-r22', u'stable-91-r29', u'stable-97-r24', u'stable-94-r53', u'stable-97-r26', u'stable-97-r27', u'stable-94-r8', u'stable-94-r9', u'stable-97-r39', u'stable-90-r16', u'stable-91-r54', u'stable-94-r2', u'stable-97-r38', u'stable-94-r4', u'stable-94-r5', u'stable-94-r6', u'stable-94-r7', u'stable-97-r37', u'stable-93-r150', u'stable-92-r98', u'stable-92-r99', u'stable-97-r36', u'stable-92-r95', u'stable-92-r96', u'stable-92-r97', u'stable-92-r90', u'stable-92-r91', u'stable-92-r92', u'stable-92-r93', u'stable-96-r54', u'stable-96-r55', u'stable-96-r57', u'stable-96-r50', u'stable-96-r51', u'stable-96-r52', u'stable-96-r53', u'stable-94-r41', u'stable-93-r81', u'stable-96-r58', u'stable-96-r59', u'stable-94-r40', u'stable-99-r3', u'stable-99-r2', u'stable-93-r19', u'stable-99-r6', u'stable-99-r5', u'stable-99-r4', u'stable-93-r15', u'stable-93-r149', u'stable-99-r9', u'stable-94-r42', u'stable-93-r11', u'stable-93-r10', u'stable-93-r13', u'stable-93-r12', u'stable-90-r52', u'stable-90-r53', u'stable-90-r50', u'stable-90-r51', u'stable-97-r114', u'stable-90-r34', u'stable-92-r105', u'stable-92-r104', u'stable-92-r107', u'stable-92-r106', u'stable-92-r101', u'stable-92-r100', u'stable-92-r103', u'stable-92-r102', u'stable-98-r71', u'stable-92-r109', u'stable-92-r108', u'stable-90-r15', u'stable-93-r107', u'stable-92-r61', u'stable-92-r60', u'stable-92-r63', u'stable-92-r62', u'stable-92-r65', u'stable-92-r64', u'stable-92-r67', u'stable-92-r66', u'stable-92-r69', u'stable-92-r68', u'stable-90-r12', u'stable-97-r80', u'stable-93-r84', u'stable-97-r98', u'stable-89-r2', u'stable-96-r15', u'stable-94-r165', u'stable-94-r164', u'stable-94-r167', u'stable-94-r166', u'stable-94-r161', u'stable-94-r160', u'stable-94-r163', u'stable-94-r162', u'stable-94-r81', u'stable-94-r80', u'stable-97-r175', u'stable-99-r58', u'stable-94-r169', u'stable-94-r168', u'stable-94-r87', u'stable-94-r86', u'stable-99-r100', u'stable-99-r101', u'stable-99-r102', u'stable-99-r103', u'stable-89-r25', u'stable-94-r29', u'stable-89-r27', u'stable-99-r107', u'stable-99-r108', u'stable-99-r109', u'stable-94-r28', u'stable-93-r69', u'stable-89-r8', u'stable-92-r50', u'stable-98-r58', u'stable-98-r59', u'stable-93-r92', u'stable-97-r90', u'stable-98-r52', u'stable-98-r53', u'stable-98-r50', u'stable-98-r51', u'stable-98-r56', u'stable-98-r57', u'stable-98-r54', u'stable-98-r55', u'stable-96-r87', u'stable-96-r86', u'stable-96-r85', u'stable-97-r12', u'stable-96-r83', u'stable-97-r14', u'stable-97-r17', u'stable-96-r80', u'stable-97-r19', u'stable-97-r18', u'stable-96-r89', u'stable-96-r88', u'stable-96-r64', u'stable-97-r97', u'stable-93-r172', u'stable-90-r11', u'stable-97-r96', u'stable-97-r117', u'stable-93-r171', u'stable-93-r137', u'stable-93-r136', u'stable-93-r135', u'stable-93-r134', u'stable-93-r133', u'stable-93-r132', u'stable-93-r131', u'stable-97-r190', u'stable-93-r177', u'stable-97-r109', u'stable-97-r193', u'stable-93-r139', u'stable-93-r138', u'stable-95-r26', u'stable-95-r27', u'stable-95-r24', u'stable-95-r25', u'stable-97-r186', u'stable-97-r187', u'stable-95-r20', u'stable-94-r15', u'stable-95-r17', u'stable-94-r18', u'stable-94-r19', u'stable-95-r28', u'stable-95-r29', u'stable-97-r146', u'stable-94-r10', u'stable-97-r197', u'stable-97-r147', u'stable-93-r152', u'stable-97-r196', u'stable-92-r81', u'stable-96-r18', u'stable-99-r68', u'stable-92-r80', u'stable-97-r69', u'stable-96-r10', u'stable-96-r11', u'stable-96-r12', u'stable-96-r13', u'stable-96-r14', u'stable-94-r11', u'stable-96-r16', u'stable-97-r143', u'stable-99-r53', u'stable-93-r178', u'stable-97-r140', u'stable-99-r52', u'stable-88-r54', u'stable-99-r51', u'stable-93-r51', u'stable-93-r50', u'stable-93-r53', u'stable-93-r52', u'stable-93-r55', u'stable-93-r54', u'stable-93-r57', u'stable-93-r56', u'stable-93-r59', u'stable-89-r49', u'stable-91-r51', u'stable-94-r16', u'stable-92-r89', u'stable-94-r47', u'stable-99-r56', u'stable-97-r102', u'stable-92-r88', u'stable-97-r179', u'stable-93-r83', u'stable-97-r178', u'stable-98-r14', u'stable-99-r29', u'stable-97-r176', u'stable-94-r17', u'stable-99-r59', u'stable-99-r30', u'stable-94-r82', u'stable-96-r69', u'stable-96-r68', u'stable-94-r3', u'stable-96-r65', u'stable-97-r173', u'stable-96-r67', u'stable-96-r66', u'stable-96-r61', u'stable-96-r60', u'stable-96-r63', u'stable-94-r84', u'stable-94-r132', u'stable-97-r116', u'stable-99-r127', u'stable-97-r171', u'stable-94-r133', u'stable-97-r170', u'stable-94-r130', u'stable-99-r17', u'stable-89-r21', u'stable-99-r15', u'stable-88-r45', u'stable-99-r13', u'stable-99-r12', u'stable-99-r11', u'stable-89-r20', u'stable-90-r23', u'stable-88-r42', u'stable-90-r21', u'stable-98-r28', u'stable-90-r27', u'stable-94-r124', u'stable-99-r19', u'stable-99-r18', u'stable-97-r133', u'stable-97-r132', u'stable-97-r131', u'stable-89-r22', u'stable-97-r137', u'stable-88-r40', u'stable-97-r135', u'stable-97-r134', u'stable-97-r139', u'stable-97-r138', u'stable-99-r148', u'stable-97-r103', u'stable-99-r179', u'stable-89-r19', u'stable-89-r7', u'stable-89-r26', u'stable-90-r30', u'stable-88-r57', u'stable-89-r29', u'stable-94-r99', u'stable-92-r38', u'stable-89-r28', u'stable-92-r36', u'stable-92-r37', u'stable-92-r34', u'stable-92-r35', u'stable-92-r32', u'stable-92-r33', u'stable-92-r30', u'stable-92-r31', u'stable-91-r9', u'stable-90-r41', u'stable-88-r10', u'stable-96-r3', u'stable-90-r43', u'stable-99-r88', u'stable-99-r89', u'stable-93-r179', u'stable-88-r12', u'stable-94-r46', u'stable-89-r11', u'stable-99-r80', u'stable-99-r81', u'stable-99-r82', u'stable-99-r83', u'stable-99-r84', u'stable-99-r85', u'stable-99-r86', u'stable-99-r87', u'stable-98-r4', u'stable-98-r5', u'stable-98-r6', u'stable-98-r7', u'stable-97-r142', u'stable-94-r105', u'stable-98-r2', u'stable-97-r141', u'stable-99-r175', u'stable-88-r16', u'stable-98-r8', u'stable-98-r9', u'stable-97-r148', u'stable-97-r149', u'stable-88-r19', u'stable-97-r184', u'stable-89-r9', u'stable-89-r16', u'stable-93-r185', u'stable-88-r18', u'stable-89-r17', u'stable-99-r174', u'stable-99-r60', u'stable-97-r48', u'stable-97-r49', u'stable-97-r46', u'stable-97-r47', u'stable-97-r44', u'stable-89-r42', u'stable-97-r42', u'stable-97-r43', u'stable-97-r40', u'stable-97-r41', u'stable-93-r33', u'stable-90-r10', u'stable-93-r42', u'stable-91-r47', u'stable-93-r100', u'stable-93-r95', u'stable-93-r94', u'stable-93-r97', u'stable-96-r6', u'stable-99-r144', u'stable-93-r90', u'stable-91-r19', u'stable-91-r18', u'stable-91-r17', u'stable-91-r16', u'stable-91-r15', u'stable-91-r14', u'stable-91-r13', u'stable-91-r12', u'stable-91-r11', u'stable-91-r10', u'stable-93-r7', u'stable-94-r69', u'stable-89-r4', u'stable-99-r76', u'stable-94-r63', u'stable-94-r62', u'stable-94-r61', u'stable-94-r60', u'stable-94-r67', u'stable-94-r66', u'stable-94-r65', u'stable-94-r64', u'stable-98-r35', u'stable-97-r11', u'stable-97-r10', u'stable-89-r10', u'stable-98-r10', u'stable-89-r1', u'stable-94-r127', u'stable-97-r13', u'stable-97-r150', u'stable-93-r99', u'stable-90-r35', u'stable-97-r15', u'stable-96-r4', u'stable-96-r21', u'stable-96-r20', u'stable-96-r23', u'stable-96-r22', u'stable-96-r25', u'stable-96-r81', u'stable-96-r27', u'stable-96-r26', u'stable-96-r29', u'stable-96-r28', u'stable-97-r16', u'stable-91-r46', u'stable-88-r44', u'stable-93-r98', u'stable-93-r6', u'stable-90-r19', u'stable-91-r40', u'stable-94-r12', u'stable-96-r5', u'stable-91-r42', u'stable-97-r185', u'stable-93-r45', u'stable-95-r40', u'stable-92-r130', u'stable-92-r131', u'stable-92-r132', u'stable-92-r133', u'stable-92-r134', u'stable-92-r135', u'stable-92-r136', u'stable-93-r91', u'stable-97-r9', u'stable-97-r104', u'stable-97-r82', u'stable-93-r86', u'stable-90-r18', u'stable-88-r80', u'stable-88-r81', u'stable-92-r72', u'stable-92-r73', u'stable-92-r70', u'stable-92-r71', u'stable-92-r76', u'stable-92-r77', u'stable-92-r74', u'stable-92-r75', u'stable-94-r91', u'stable-92-r78', u'stable-92-r79', u'stable-93-r104', u'stable-93-r105', u'stable-99-r48', u'stable-99-r49', u'stable-99-r44', u'stable-93-r102', u'stable-99-r46', u'stable-95-r42', u'stable-99-r40', u'stable-99-r41', u'stable-99-r42', u'stable-99-r43', u'stable-94-r150', u'stable-94-r151', u'stable-94-r98', u'stable-94-r153', u'stable-94-r154', u'stable-94-r155', u'stable-94-r156', u'stable-94-r157', u'stable-94-r92', u'stable-94-r93', u'stable-94-r90', u'stable-97-r101', u'stable-99-r113', u'stable-99-r112', u'stable-99-r111', u'stable-94-r95', u'stable-89-r32', u'stable-89-r33', u'stable-89-r30', u'stable-89-r31', u'stable-89-r36', u'stable-89-r37', u'stable-89-r34', u'stable-89-r35', u'stable-95-r43', u'stable-89-r38', u'stable-89-r39', u'stable-90-r32', u'stable-98-r67', u'stable-98-r65', u'stable-98-r64', u'stable-98-r63', u'stable-98-r62', u'stable-98-r61', u'stable-98-r60', u'stable-88-r37', u'stable-88-r36', u'stable-88-r35', u'stable-88-r34', u'stable-88-r33', u'stable-88-r32', u'stable-98-r69', u'stable-98-r68', u'stable-96-r90', u'stable-96-r91', u'stable-96-r92', u'stable-96-r93', u'stable-96-r94', u'stable-96-r95', u'stable-96-r96', u'stable-95-r44', u'stable-96-r98', u'stable-96-r99', u'stable-90-r33', u'stable-97-r160', u'stable-98-r89', u'stable-98-r88', u'stable-98-r85', u'stable-98-r84', u'stable-98-r87', u'stable-98-r86', u'stable-98-r81', u'stable-98-r80', u'stable-98-r83', u'stable-98-r82', u'stable-93-r142', u'stable-93-r143', u'stable-93-r140', u'stable-93-r141', u'stable-93-r146', u'stable-93-r147', u'stable-93-r144', u'stable-93-r145', u'stable-94-r27', u'stable-94-r26', u'stable-93-r148', u'stable-94-r24', u'stable-94-r23', u'stable-94-r22', u'stable-94-r21', u'stable-94-r20', u'stable-95-r13', u'stable-95-r12', u'stable-95-r11', u'stable-97-r192', u'stable-97-r195', u'stable-95-r16', u'stable-95-r15', u'stable-95-r14', u'stable-97-r199', u'stable-97-r198', u'stable-95-r19', u'stable-95-r18', u'stable-95-r46', u'stable-92-r8', u'stable-92-r9', u'stable-92-r6', u'stable-92-r7', u'stable-92-r4', u'stable-92-r5', u'stable-92-r2', u'stable-92-r3', u'stable-90-r22', u'stable-92-r1', u'stable-97-r28', u'stable-93-r164', u'stable-94-r138', u'stable-93-r165', u'stable-98-r19', u'stable-93-r166', u'stable-97-r182', u'stable-93-r167', u'stable-94-r13', u'stable-93-r160', u'stable-97-r180', u'stable-93-r161', u'stable-91-r44', u'stable-93-r43', u'stable-93-r40', u'stable-93-r41', u'stable-93-r46', u'stable-93-r47', u'stable-93-r44', u'stable-91-r43', u'stable-95-r22', u'stable-93-r48', u'stable-93-r163', u'stable-91-r48', u'stable-91-r49', u'stable-98-r36', u'stable-95-r23', u'stable-93-r9', u'stable-99-r191', u'stable-89-r15', u'stable-93-r5', u'stable-93-r4', u'stable-93-r8', u'stable-95-r21', u'stable-93-r1', u'stable-89-r18', u'stable-93-r3', u'stable-93-r2', u'stable-97-r174', u'stable-97-r83', u'stable-89-r12', u'stable-97-r188', u'stable-95-r7', u'stable-90-r38', u'stable-94-r85', u'stable-96-r78', u'stable-99-r67', u'stable-96-r76', u'stable-96-r77', u'stable-96-r79', u'stable-96-r72', u'stable-99-r64', u'stable-96-r70', u'stable-96-r71', u'stable-95-r4', u'stable-89-r64', u'stable-95-r3', u'stable-95-r2', u'stable-88-r64', u'stable-88-r65', u'stable-88-r66', u'stable-88-r67', u'stable-88-r60', u'stable-94-r55', u'stable-88-r62', u'stable-88-r63', u'stable-96-r2', u'stable-94-r103', u'stable-88-r69', u'stable-96-r73', u'stable-99-r153', u'stable-99-r152', u'stable-99-r151', u'stable-90-r36', u'stable-99-r157', u'stable-93-r158', u'stable-99-r155', u'stable-99-r154', u'stable-99-r159', u'stable-99-r158', u'stable-96-r75', u'stable-89-r5', u'stable-88-r79', u'stable-99-r147', u'stable-94-r102', u'stable-90-r17', u'stable-99-r125', u'stable-94-r147', u'stable-88-r51', u'stable-99-r150', u'stable-95-r9', u'stable-91-r2', u'stable-99-r69', u'stable-91-r1', u'stable-94-r89', u'stable-89-r54', u'stable-88-r78', u'stable-94-r144', u'stable-95-r41', u'stable-94-r101', u'stable-91-r7', u'stable-99-r137', u'stable-91-r6', u'stable-99-r75', u'stable-99-r74', u'stable-99-r77', u'stable-89-r57', u'stable-99-r71', u'stable-91-r5', u'stable-99-r73', u'stable-99-r72', u'stable-99-r131', u'stable-94-r140', u'stable-99-r79', u'stable-99-r78', u'stable-94-r88', u'stable-94-r50', u'stable-97-r155', u'stable-97-r154', u'stable-97-r157', u'stable-97-r156', u'stable-97-r151', u'stable-99-r133', u'stable-97-r153', u'stable-97-r152', u'stable-89-r43', u'stable-95-r55', u'stable-89-r41', u'stable-99-r132', u'stable-97-r159', u'stable-97-r158', u'stable-99-r128', u'stable-99-r129', u'stable-99-r156', u'stable-97-r168', u'stable-88-r43', u'stable-98-r38', u'stable-97-r169', u'stable-90-r14', u'stable-97-r162', u'stable-98-r37', u'stable-98-r30', u'stable-94-r51', u'stable-98-r32', u'stable-98-r33', u'stable-89-r13', u'stable-94-r114', u'stable-97-r79', u'stable-97-r78', u'stable-94-r107', u'stable-94-r115', u'stable-97-r73', u'stable-89-r58', u'stable-97-r71', u'stable-97-r70', u'stable-97-r77', u'stable-94-r116', u'stable-97-r75', u'stable-89-r59', u'stable-97-r111', u'stable-94-r117', u'stable-88-r15', u'stable-99-r163', u'stable-94-r110', u'stable-89-r23', u'stable-89-r14', u'stable-88-r61', u'stable-94-r131', u'stable-93-r87', u'stable-94-r106', u'stable-93-r85', u'stable-93-r119', u'stable-94-r112', u'stable-93-r80', u'stable-97-r144', u'stable-93-r115', u'stable-93-r114', u'stable-94-r113', u'stable-93-r111', u'stable-93-r110', u'stable-94-r120', u'stable-93-r89', u'stable-94-r74', u'stable-94-r75', u'stable-94-r76', u'stable-94-r77', u'stable-94-r70', u'stable-94-r71', u'stable-94-r72', u'stable-94-r73', u'stable-94-r94', u'stable-96-r17', u'stable-94-r78', u'stable-94-r79', u'stable-95-r51', u'stable-97-r201', u'stable-94-r136', u'stable-97-r145', u'stable-97-r172', u'stable-88-r50', u'stable-88-r68', u'stable-94-r119', u'stable-88-r73', u'stable-90-r31', u'stable-94-r104', u'stable-96-r32', u'stable-96-r33', u'stable-96-r30', u'stable-96-r31', u'stable-96-r36', u'stable-96-r37', u'stable-96-r34', u'stable-96-r35', u'stable-96-r38', u'stable-96-r39', u'stable-93-r39', u'stable-93-r38', u'stable-99-r36', u'stable-88-r72', u'stable-96-r82', u'stable-93-r32', u'stable-94-r14', u'stable-93-r30', u'stable-93-r37', u'stable-93-r36', u'stable-93-r35', u'stable-93-r34', u'stable-92-r129', u'stable-92-r128', u'stable-92-r127', u'stable-92-r126', u'stable-92-r125', u'stable-92-r124', u'stable-92-r123', u'stable-92-r122', u'stable-92-r121', u'stable-92-r120', u'stable-94-r123', u'stable-97-r8', u'stable-88-r71', u'stable-97-r181', u'stable-94-r135', u'stable-97-r3', u'stable-97-r2', u'stable-97-r5', u'stable-97-r4', u'stable-97-r7', u'stable-97-r6', u'stable-97-r189', u'stable-98-r70', u'stable-99-r141', u'stable-92-r49', u'stable-92-r48', u'stable-92-r47', u'stable-92-r46', u'stable-92-r45', u'stable-92-r44', u'stable-92-r43', u'stable-92-r42', u'stable-92-r41', u'stable-92-r40', u'stable-98-r24', u'stable-97-r91', u'stable-97-r92', u'stable-98-r29', u'stable-93-r173', u'stable-99-r193', u'stable-97-r194', u'stable-99-r39', u'stable-99-r38', u'stable-90-r28', u'stable-91-r8', u'stable-88-r59', u'stable-88-r58', u'stable-94-r149', u'stable-94-r148', u'stable-88-r55', u'stable-94-r146', u'stable-94-r145', u'stable-88-r56', u'stable-94-r143', u'stable-94-r142', u'stable-94-r141', u'stable-88-r52', u'stable-88-r77', u'stable-91-r53', u'stable-99-r168', u'stable-99-r169', u'stable-93-r118', u'stable-91-r52', u'stable-99-r162', u'stable-99-r192', u'stable-97-r113', u'stable-99-r161', u'stable-97-r115', u'stable-99-r167', u'stable-99-r164', u'stable-99-r165', u'stable-94-r83', u'stable-88-r76', u'stable-91-r56', u'stable-88-r28', u'stable-88-r29', u'stable-98-r72', u'stable-98-r74', u'stable-98-r75', u'stable-98-r76', u'stable-98-r77', u'stable-88-r20', u'stable-88-r21', u'stable-88-r22', u'stable-88-r23', u'stable-88-r24', u'stable-88-r25', u'stable-88-r26', u'stable-88-r27'])


@memoize
def tag_to_commit():
    return {
        rec['tag']: str(rec['commit'])
        for rec in tags().find()
    }


def main():
    for tag in sorted(BAD_TAGS):
        print '  - start', tag
        try:
            print '  - remove searcher_lookup'
            searcher_lookup().remove({
                'commit': int(tag_to_commit()[tag])
            })
            print '  - sleep 60'
            time.sleep(60)
            print '  - remove groups'
            groups().remove({
                'commit': str(tag_to_commit()[tag])
            })
            print '  - sleep 60'
            time.sleep(60)
        except:
            logging.exception('tag %s failed', tag)
            time.sleep(0.5)


if __name__ == '__main__':
    main()
