import libraries.topology.searcher_lookup as lookup
import libraries.topology as topology


def get_samogon_mtn_hostnames(prj):
    groups = lookup.load_full_trunk(topology.get_latest_success_commit())

    for group in groups.itervalues():
        prjs = group.get()['card']['tags']['prj']
        if prj in prjs and 'samogon' in prjs:
            for instance in group.get().get('instances', {}):
                try:
                    yield instance['hbf']['interfaces']['backbone']['hostname']
                except KeyError:
                    pass


def main():
    for vm in get_samogon_mtn_hostnames(prj='vhfrontend'):
        print vm


if __name__ == '__main__':
    main()
