import json
import pymongo

from mongo_params import INFRA_MONGODB

_coll = pymongo.MongoReplicaSetClient(
    INFRA_MONGODB.uri,
    connectTimeoutMS=500,
    replicaSet=INFRA_MONGODB.replicaset,
    w='majority',
    wtimeout=5000,
    read_preference=INFRA_MONGODB.read_preference,
)['topology']['hosts']


def main():
    with open('./gencfg/db/hardware_data/hosts_data', 'r') as f:
        hosts = json.load(f)
        print len(hosts)
        for i, host in enumerate(hosts):
            if i % 1000 == 0:
                print i, host
            _coll.update(
                {'invnum': host['invnum']},
                host,
                upsert=True,
            )
        pass


if __name__ == '__main__':
    main()
