from concurrent.futures import ProcessPoolExecutor


class LimitedPool(object):
    def __init__(self, max_workers):
        self.max_pending_count = max_workers * 3
        self.pending_count = 0
        self.executor = ProcessPoolExecutor(max_workers=max_workers)

    def submit(self, task, *args, **kwargs):
        if self.pending_count >= self.max_pending_count:
            raise PoolOverflow()

        future = self.executor.submit(task, args, kwargs)
        future.add_done_callback(self._task_done)
        self.pending_count += 1

        return future

    def shutdown(self, wait=True):
        self.executor.shutdown(wait)

    def _task_done(self, _):
        self.pending_count -= 1


class PoolOverflow(RuntimeError):
    pass
