%define _builddir	.
%define _sourcedir	.
%define _specdir	.
%define _rpmdir		.

Name:		conductor-agent
Version:	%(cat debian/changelog | head -1 | cut -f2 -d\( | cut -f1 -d\))
Release:	1

Summary:	Conductor agent
License:	Yandex License
Group:		System environment/Extra
Distribution:	Red Hat Enterprise Linux
Requires:	yandex-python
Requires:	yum-plugin-trivial

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root


%description
Conductor agent


%prep


%build


%post
mkdir -p /var/log/conductor-agent
if [ -f /etc/init/conductor-agent.conf ]; then
    /sbin/initctl stop conductor-agent
    /sbin/initctl start conductor-agent
fi
if [ -f /etc/init.d/conductor-agent ]; then
    /sbin/chkconfig --add conductor-agent
    /sbin/chkconfig --level 35 conductor-agent on
    /sbin/service conductor-agent start
fi
# remove "#Defaults requiretty" REPORTS-1539
if !(grep -q "^#Defaults\s\+requiretty" /etc/sudoers); then
    if grep -q "Defaults\s\+requiretty" /etc/sudoers ; then
        sed -i 's/Defaults\(\s\+\)requiretty/#Defaults\1requiretty/' /etc/sudoers
        echo "Commented out \`Defaults requiretty\` from sudoers"
    fi
fi


%preun
if [ -f /etc/init/conductor-agent.conf ]; then
    /sbin/initctl stop conductor-agent || /bin/true
fi
if [ -f /etc/init.d/conductor-agent ]; then
    /sbin/service conductor-agent stop
    /sbin/chkconfig --del conductor-agent
fi


%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/usr/lib/yandex/conductor-agent
mkdir -p %{buildroot}/usr/sbin
mkdir -p %{buildroot}/etc/conductor-agent
mkdir -p %{buildroot}/opt/python/lib/python2.7/site-packages
cp -a main.py conductor %{buildroot}/usr/lib/yandex/conductor-agent
cp -a conductor-agent %{buildroot}/usr/sbin
cp -a conf/* %{buildroot}/etc/conductor-agent
cp -a contrib/* %{buildroot}/opt/python/lib/python2.7/site-packages
echo `cat debian/changelog | head -1 | cut -f2 -d\( | cut -f1 -d\)` > %{buildroot}/etc/conductor-agent/version
%if 0%{?rhel} == 5
    mkdir -p %{buildroot}/etc/init.d
    cp -a startup/rhel5/* %{buildroot}/etc/init.d
%else
    cp -a startup/init %{buildroot}/etc
%endif


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
/


%changelog
* Sat Jun 27 2015 Pavel Pushkarev <paulus@yandex-team.ru>
- initial yandex's rpm build

