import yaml
import os
import os.path


default_config = """
attemptCount: 3
attemptInterval: 120

programName: 'conductor-agent'

log:  # log parameters
    logPath : '/var/log/conductor-agent/'
    mainLogFile : 'conductor-agent.log'
    logLevel : 'DEBUG'

connector:
    refreshInterval: 20
    conductorHTTP:
        apiUrl: http://c.yandex-team.ru/agent
        connectionTimeout: 10

installer:
    debianInstaller:
        aptOpts:
            APT::Get::Assume-Yes: false
"""


def getDefaultConfig():
    """
    :rtype: dict
    """
    return yaml.load(default_config)


def getConfig(main_conf=None, conf_dir=None):
    config = getDefaultConfig()

    if main_conf is not None:
        files = [main_conf]
        if conf_dir and os.path.isdir(conf_dir):
            files += [os.path.join(conf_dir, f) for f in sorted(os.listdir(conf_dir))]

        for filename in files:
            if filename.endswith('.conf'):
                config = mergeConfig(config, readConfFile(filename))

    return config


def serializeConfig(config):
    return yaml.dump(config, version=(1, 1), default_flow_style=False)


def readConfFile(conf_file):
    """
    Parse provided file into dictionary.
    Raises (hopefully) ValueError or EnvironmentError
    :rtype: dict
    """
    try:
        with open(conf_file) as f:
            conf = yaml.load(f)
            if conf is None:
                conf = {}

            return conf
    except yaml.YAMLError as e:
        raise ValueError("failed to parse cfg file '{0}': "
                         "type='{1}' msg='{2}'".format(conf_file, e.__class__.__name__, str(e)))


def mergeConfig(default, new):
    if isinstance(default, dict) and isinstance(new, dict):
        for k, v in default.iteritems():
            if k not in new:
                new[k] = v
            else:
                new[k] = mergeConfig(v, new[k])

    return new
