import functools
import httplib
import urllib2
import socket

import DNS


__discovered = False


class DNSError(Exception):
    pass


class BoundHTTPHandler(urllib2.HTTPHandler):
    def __init__(self, source_address=None, debuglevel=0):
        urllib2.HTTPHandler.__init__(self, debuglevel)
        self.http_class = functools.partial(httplib.HTTPConnection, source_address=source_address)

    def http_open(self, req):
        return self.do_open(self.http_class, req)


def __discover():
    global __discovered
    if not __discovered:
        DNS.DiscoverNameServers()
        if DNS.defaults['server']:
            __discovered = True


def resolve(fqdn, qtype):
    __discover()
    request = DNS.Request(name=fqdn, timeout=2, qtype=qtype)
    results = []
    response = request.req()
    if response:
        for answer in response.answers:
            if answer['typename'] == qtype:
                results.append(answer['data'])
    else:
        raise DNSError("Could not resolve {}: "
                       "no dns servers configured".format(fqdn))
    return results


def resolve_all(fqdn):
    return resolve6(fqdn) + resolve4(fqdn)


def resolve4(fqdn):
    return resolve(fqdn, qtype='A')


def resolve6(fqdn):
    return [socket.inet_ntop(socket.AF_INET6, res)
            for res in resolve(fqdn, qtype='AAAA')]
