from __future__ import absolute_import
import os

from .linuxinstaller import LinuxInstaller


class DebianInstaller(LinuxInstaller):
    LOCK_ERROR = 'E: Could not get lock /var/lib/dpkg/lock'

    def loadConfig(self):
        return self.ctx.cfg['installer']['debianInstaller']

    def getLog(self):
        return self.ctx.log.getChild('DebianInstaller')

    def getUpdateCommand(self):
        return ['apt-get', '-qq', 'update']

    def getRemoveCommand(self):
        return ['dpkg', '--purge']

    def getInstallCommand(self, task):
        command = ['apt-get', 'install']

        try:
            if self.cfg.get('noninteractive'):
                os.environ['DEBIAN_FRONTEND'] = 'noninteractive'
        except Exception:
            pass

        for opt in self.cfg.get('aptOpts', []):
            values = self.cfg['aptOpts'][opt]
            values = values if isinstance(values, list) else (values,)
            command += reduce(lambda y, z: y + z, [['-o', '%s=%s' % (opt, x)] for x in values], [])
        packageOptions = self.cfg.get('packages', {})
        for k, v in self.ctx.cfg.get('packages', {}).items():
            packageOptions[k] = v
        for package in task.packages:
            opts = []
            if package.name in packageOptions:
                opts = self.getPackageOptions(package, packageOptions[package.name])
            elif hasattr(package, 'downgrade') and package.downgrade and 'downgrade' in self.cfg:
                for opt in self.cfg['downgrade'].get('aptOpts', []):
                    values = self.cfg['downgrade']['aptOpts'][opt]
                    values = values if isinstance(values, list) else (values,)
                    command += reduce(lambda y, z: y + z, [['-o', '%s=%s' % (opt, x)] for x in values], [])
                opts += self.cfg['downgrade'].get('installerArgs', [])

            for opt in opts:
                if opt not in command:
                    command.append(opt)
        return command

    def getPackageOptions(self, package, config):
        result = []
        if hasattr(package, 'downgrade') and package.downgrade and 'downgrade' in config:
            result += config['downgrade'].get('installerArgs', [])
        result += config.get('installerArgs', [])
        return result

    def commandIgnorable(self):
        i = len(self._logs) - 1
        while i >= 0:
            if self.LOCK_ERROR in self._logs[i]:
                return True
            i -= 1
        return False


# import os, fcntl, time
#
# f = open('/var/lib/dpkg/lock', 'w')
# fcntl.lockf(f.fileno(), fcntl.LOCK_EX, 0, 0, os.SEEK_SET)
