from __future__ import absolute_import

from .linuxinstaller import LinuxInstaller


class RedhatInstaller(LinuxInstaller):
    PACKAGE_DELIMITER = '-'

    def loadConfig(self):
        return self.ctx.cfg['installer']['redhatInstaller']

    def getLog(self):
        return self.ctx.log.getChild('RedhatInstaller')

    def getUpdateCommand(self):
        return ['yum', 'clean', 'metadata']

    def getRemoveCommand(self):
        return ['yum', 'remove']

    def getInstallCommand(self, task):
        return ['yum', 'replace', '--trivial']
