import traceback


class FileProxy(object):
    def __init__(self, fd, logs):
        self._fd = fd
        self._logs = logs

    def write(self, s):
        self._logs.append(s)
        try:
            r = self._fd.write(s)
        except IOError:
            self._logs.append("Error writing to task log")
            self._logs.append(traceback.format_exc())
            r = 0
        return r

    def __getattr__(self, item):
        return getattr(self._fd, item)
