import os.path

from logging import StreamHandler


__all__ = ['ReopenFileHandler']


class ReopenFileHandler(StreamHandler):
    """File handler which supports reopening of logs.

    Re-opening should be used instead of the 'rollover' feature of
    the FileHandler from the standard library's logging package.
    """

    def __init__(self, filename, mode="a"):
        self.filename = os.path.abspath(filename)
        self.mode = mode
        StreamHandler.__init__(self, open(self.filename, self.mode))

    def close(self):
        self.stream.close()

    def reopen(self):
        self.close()
        self.stream = open(self.filename, self.mode)
