from __future__ import division, absolute_import

from .service import Service

class Package(object):
    def __init__(self, name, version, **attrs):
        # This attributes are mandatory. There's no need to check their existence
        self.name = name
        self.version = version
        self.services = []
        self.preServices = []

        # More attributes may be passed, but are not guaranteed to exist
        for attr in attrs:
            setattr(self, attr, attrs[attr])

    def __str__(self):
        return self.name

    def addService(self, service, pre=False):
        assert isinstance(service, Service)
        if pre:
            self.preServices.append(service)
        else:
            self.services.append(service)