from __future__ import division, absolute_import


class Service(object):
    def __init__(self, name, package=None, script=None, **attrs):
        # This attributes are mandatory. There's no need to check their existence
        self.name = name
        self.package = package
        # Actual script string depends on input parameters, specifically sudo flag and action (start/stop/restart/...)
        # script() method must be used to get a string ready for execution
        self._script = script

        # More attributes may be passed, but are not guaranteed to exist
        for attr in attrs:
            setattr(self, attr, attrs[attr])

    def fullName(self):
        if self._script is not None and '#package#' in self._script:
            return '%s##%s' % (self.name, self.package.name)
        return self.name

    def nameToScript(self, action):
        # FIXME: consider using upstart
        return "/etc/init.d/%s %s" % (self.name, action)

    def script(self, action, sudo=False):
        sudo_cmd = ''
        if sudo:
            sudo_cmd = 'sudo '

        script = self._script
        if script is None or script == '':
            script = self.nameToScript(action)

        script = script.replace('##', action)
        script = script.replace('#package#', self.package.name)
        if script.find('#sudo#') == -1:
            return '%s%s' % (sudo_cmd, script)
        else:
            return script.replace('#sudo#', sudo_cmd)

    def __str__(self):
        return self.name
