from __future__ import division, absolute_import

import time
from .package import Package


class Task(object):

    INTERNAL_ATTRS = ['attempts', 'lastAttempt']

    def __init__(self, task_id, status, operation, schedule, max_parallel, **attrs):
        self.packages = []
        self.removePackages = []
        self.id = task_id
        self.status = status
        self.operation = operation
        self.attempts = 0
        self.lastAttempt = 0
        self.schedule = schedule
        self.max_parallel = max_parallel
        self.task = None
        self.newStatus = None
        self.newStatusLog = None
        for attr in attrs:
            if attr in self.INTERNAL_ATTRS:
                continue
            setattr(self, attr, attrs[attr])

    def addPackage(self, package, remove=False):
        assert isinstance(package, Package)
        if remove:
            self.removePackages.append(package)
        else:
            self.packages.append(package)

    def incrementAttempts(self):
        self.attempts += 1
        self.lastAttempt = time.time()

    def secondsSinceLastAttempt(self):
        return time.time() - self.lastAttempt

    def can_run_now(self):
        return self.schedule.can_run_now()

    def has_work(self):
        if self.status in ('ready', 'working', 'error'):
            return True
        return False

    def rememberStatus(self, newStatus, log):
        self.newStatus = newStatus
        self.newStatusLog = log

    def hasRememberedStatus(self):
        """
        :rtype bool
        """
        return self.newStatus is not None

    def clearRememberedStatus(self):
        self.newStatus = None
        self.newStatusLog = None
